/***************************************************************************
 *   Copyright (C) 2009 by Manuel Schrape                                  *
 *   manuel.schrape@gmx.de                                                 *
 *   and Andreas Bresser bresser@informatik.uni-bremen.de                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License.        *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef LOGGER_H
#define LOGGER_H

#include <QLinkedList>
#include <QString>
#include "DefaultLogger.h"
#include "../global.h"
#include "../Classes/cSettings.h"

//Die verschiedenen header der einzelnen Logger
//TODO: MySQLLogger, SQLiteLogger und/oder PostGreSQLLogger
#include "CSVLogger.h"

class Logger
{
private:
    CSVLogger * csv;
    //Liste aller bekannten Logger
    QLinkedList<DefaultLogger *> logger;

    bool active;

public:
    Logger(cSettings * settings, sMode * mode);
    ~Logger();

    void start_Log();

    //soll geloggt werden?
    bool is_active();

    //schreibe log
    void write(int * analogData);

    //alles schließen
    void close();
};
#endif
